#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7OrgMessage : BaseTest 
	{
		#region Variables & Setup

		private static string _hl7Message;

		HL7OrgMessage _orgMessage;

		static Messages_HL7OrgMessage()
		{
			_hl7Message = string.Concat(
				"MSH|^~\\&|OERR|589|VBECS|589|20080526140139-0500||ORG^O20|5894312175|T|2.4|||||USA",
				CARRIAGE_RETURN,
				"MSA|AA|VBECS8052602456406",
				CARRIAGE_RETURN,
				"PID|||5890045694V193464^^^^NI~493013508^^^^SS~14161^^^^PI||HALZ^ALUUN^J||19601126|M",
				CARRIAGE_RETURN,
				"ORC|NW|22179410^OR||22179406^OR|||||200805261354-0500|53342^USER^ONE||53342^USER^ONE||||^Transfuse|589^VA HEARTLAND - WEST, VISN 15|||", 
				CARRIAGE_RETURN,
				"OBR|1|22179410^OR||1^TYPE \\T\\ SCREEN^99VBC^^|||||||O||89932;3080526;4;6478||^^SEND PATIENT||||||||||||^^^20080526^200805261354-0500^R^^", 
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_orgMessage = new HL7OrgMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7OrgMessage omgMessage = new HL7OrgMessage( _hl7Message );
			//
			Assert.IsTrue( omgMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7OrgMessage omgMessage = new HL7OrgMessage( null );
			//
			Assert.IsTrue( omgMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _orgMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _orgMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _orgMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _orgMessage.IsResponseRequired() == false );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _orgMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _orgMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _orgMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void ErrorText_Pass()
		{
			_orgMessage.ErrorText = "TEST";
			//
			Assert.IsNotNull( _orgMessage.ErrorText );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorText_Fail()
		{
		}

		[Test]
		public void AcknowledgementCode_Pass()
		{
			_orgMessage.AcknowledgementCode = "TEST";
			//
			Assert.IsNotNull( _orgMessage.AcknowledgementCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AcknowledgementCode_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _orgMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void MSA_Pass()
		{
			Assert.IsNotNull( _orgMessage.MSA );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSA_Fail()
		{
		}

		[Test]
		public void PID_Pass()
		{
			Assert.IsNotNull( _orgMessage.ORC );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PID_Fail()
		{
		}

		[Test]
		public void ORC_Pass()
		{
			Assert.IsNotNull( _orgMessage.OBR );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ORC_Fail()
		{
		}

		[Test]
		public void OBR_Pass()
		{
			Assert.IsNotNull( _orgMessage.OBR );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OBR_Fail()
		{
		}

		#endregion
	}
}
#endif